//	CFinderWindow.c

#include "CDiskMapWindow.h"
#include "FSUtils.h"
#include "Open_Save.h"
#include "DSUserProcs.h"
#include "CDialogReplaceFile.h"
#include "CDialogDeleteFile.h"
#include "CDialogNewDisk.h"
#include "CDialogPrefs.h"
#include "CDialogCopy.h"
#include "Carbon68kGlue.h"
#include "CDialogGetInfo.h"
#include "CDisk.h"
#include "CFile.h"
#include "ADFS_O_Callbacks.h"
#include "ADFS_Prefs.h"
#include "ADFS_Menus.h"
#include "CFinderWindow.h"

Boolean		CFinderWindow::IFinderWindow(
	ADFS_WindowType			windowType, 
	short					resourceID, 
	O_TopicRef	*topicRef 
) {
	Boolean			success = TRUE;
	
	success = _inherited::IOutlineWindow(windowType, resourceID, topicRef);
			
	return success;
}

Boolean		CFinderWindow::IsIconView(void)
{
	return i_header->i_viewAs == cmdViewAsIcons;
}

void		CFinderWindow::UnCacheStats(void)
{
	//	items, free, used etc
}

void		CFinderWindow::PreDraw(void)
{
	if (IsIconView()) {
		Rect	theRect = GetWindowRect(WindowRect_INTERIOR);
		
		EraseRect(&theRect);		
	}
	
	_inherited::PreDraw();
}

void		CFinderWindow::Draw(void)
{
	_inherited::Draw();
}

void		CFinderWindow::PostDraw(long bottom)
{
	if (!IsIconView()) {
		_inherited::PostDraw(bottom);
	}
}

CEntry			*CFinderWindow::GetFirstEntry(void)
{
	O_CTopic		*topicP = GetFirstTopic();
	CEntry			*entryP = NULL;
	
	if (topicP) entryP = GetTopicEntry(topicP);
	
	return entryP;
}

void			CFinderWindow::UpdateSort(Boolean recurseB)
{
	CEntry		*entryP		= GetFirstEntry();
	
	if (entryP) {
		entryP = entryP->GetParent();

		if (entryP) {
			entryP->UpdateSort(recurseB);
		}
	}
}

Rect			CFinderWindow::MarqueeSelect(Point	hitPoint, ulong modifiers)
{
	Rect	theRect = _inherited::MarqueeSelect(hitPoint, modifiers);
	
	if (!EmptyRect(&theRect)) {
		CEntry		*entryP = GetFirstEntry();
		
		if (entryP) {
			O_CBData_MARQUEE		marquee;
			
			marquee.theRect = theRect;
			marquee.toggleB = (modifiers & cmdKey) != 0;
			
			entryP->ApplyToOnScreenItems(
				O_CB_MARQUEE, 
				&marquee);
		}
	}
	
	return theRect;
}

ulong			CFinderWindow::CountSelectedTypes(
	ADFS_O_CBData_COUNT_TYPES *ctP)
{
	ulong			totalL		= 0;
	CEntry			*entryP	= GetFirstEntry();
	
	structclr(*ctP);
	
	if (entryP) {
		entryP->ApplyToSelection(ADFS_O_CB_COUNT_TYPES, ctP);
		
		ctP->types = 
			  ((ctP->files_normal		!= 0) * kFileSelected)
			| ((ctP->files_deleted		!= 0) * kDeletedFileSelected)
			| ((ctP->folders_normal		!= 0) * kFolderSelected)
			| ((ctP->folders_deleted	!= 0) * kDeletedFolderSelected)
			| ((ctP->disks				!= 0) * kDiskSelected);

		totalL = 
			  ctP->files_normal 
			+ ctP->files_deleted 
			+ ctP->folders_normal 
			+ ctP->folders_deleted 
			+ ctP->disks;
	}
	
	return totalL;
}

CEntryArray		*CFinderWindow::GetSelectedDisks(void)
{
	ADFS_O_CBData_GET_SEL	getSel;
	
	getSel.arrayP				= GetNewEntryArray();
	getSel.not_if_ancestor_selB	= FALSE;

	if (getSel.arrayP) {
		CEntry			*entryP = GetFirstEntry();
		
		if (entryP) {
			entryP->ApplyToSelection(
				ADFS_O_CB_PANE_ARRAY_GET_SEL_DISKS, 
				&getSel);
		}
	}
	
	return getSel.arrayP;
}

CDisk		*CFinderWindow::IsDiskSelected(ulong *countP0)
{
	CEntryArray		*selectionP = GetSelectedDisks();
	CDisk			*diskP		= NULL;

	if (selectionP) {
		if (selectionP->Count() != 0) {
			diskP = (CDisk *)selectionP->GetIndEntry(0);
			
			if (countP0) {
				*countP0 = selectionP->Count();
			}
		}
		
		selectionP->Dispose();
	}
	
	return diskP;
}

CEntryArray		*CFinderWindow::GetDisksOfSelection(CEntryArray *selectionP)
{
	CEntryArray		*disksP = GetNewEntryArray();
	
	if (disksP) {
		(void)selectionP->Iterate(TA_Iterate_GET_DISKS_OF_SELECTION, disksP);
	}
	
	return disksP;
}

CEntryArray		*CFinderWindow::GetSelFilesFolders(void)
{
	ADFS_O_CBData_GET_SEL	getSel;
	
	getSel.arrayP				= GetNewEntryArray();
	getSel.not_if_ancestor_selB	= TRUE;

	if (getSel.arrayP) {
		CEntry			*entryP = GetFirstEntry();
		
		if (entryP) {
			entryP->ApplyToSelection(
				ADFS_O_CB_PANE_ARRAY_GET_SEL_FILES_FOLDERS, 
				&getSel);
		}
	}
	
	return getSel.arrayP;
}

CEntryArray		*CFinderWindow::GetSelectedFiles(void)
{
	ADFS_O_CBData_GET_SEL	getSel;
	
	getSel.arrayP				= GetNewEntryArray();
	getSel.not_if_ancestor_selB	= FALSE;

	if (getSel.arrayP) {
		CEntry			*entryP = GetFirstEntry();
		
		if (entryP) {
			entryP->ApplyToSelection(
				ADFS_O_CB_PANE_ARRAY_GET_SEL_FILES, 
				&getSel);
		}
	}
	
	return getSel.arrayP;
}

OSErr		CFinderWindow::GetSelectionRgn(RgnHandle theRgn)
{
	OSErr			err			= noErr;
	CEntry			*entryP	= GetFirstEntry();
	
	if (entryP == NULL) err = 1;
	
	if (!err) {
		SetEmptyRgn(theRgn);
		
		entryP->ApplyToSelection(
			ADFS_O_CB_PANE_ARRAY_GET_SEL_RGNS, 
			theRgn);
	}
	
	return err;
}

CEntryArray		*CFinderWindow::GetDragSelection(void)
{
	CEntryArray		*arrayP = GetNewEntryArray();
	
	if (arrayP) {
		CEntry			*entryP = GetFirstEntry();
		
		if (entryP) {
			entryP->ApplyToSelection(
				ADFS_O_CB_PANE_ARRAY_GET_SEL_DRAG, 
				arrayP);
		}
	}
	
	return arrayP;
}

CEntryArray		*CFinderWindow::GetSelection(void)
{
	ADFS_O_CBData_GET_SEL	getSel;
	
	getSel.arrayP				= GetNewEntryArray();
	getSel.not_if_ancestor_selB	= FALSE;
	
	if (getSel.arrayP) {
		CEntry			*entryP = GetFirstEntry();
		
		if (entryP) {
			entryP->ApplyToSelection(
				ADFS_O_CB_PANE_ARRAY_GET_SEL, 
				&getSel);
		}
	}
	
	return getSel.arrayP;
}

Boolean		CFinderWindow::IsOneEntrySelected(CEntry **entryH)
{
	CEntryArray		*arrayP = GetSelection();
	
	*entryH = NULL;
	
	if (arrayP) {
		if (arrayP->Count() == 1) {
			*entryH = arrayP->GetIndEntry(0);
		}
		
		arrayP->Dispose();
	}
	
	return *entryH != NULL;
}

CEntry		*CFinderWindow::IsFileSelected(ulong *countP0)
{
	CEntryArray		*selectionP = GetSelectedFiles();
	CEntry			*entryP = NULL;

	if (selectionP) {
		if (selectionP->Count() != 0) {
			entryP = selectionP->GetIndEntry(0);
			
			if (countP0) {
				*countP0 = selectionP->Count();
			}
		}
		
		selectionP->Dispose();
	}
	
	return entryP;
}

CFolder		*CFinderWindow::IsFolderSelected(ulong *countP0)
{
	CEntryArray		*selectionP = GetSelection();
	CFolder			*folderP = NULL;

	if (selectionP) {
		long	maxEntriesL = selectionP->Count();
		long	curEntryL;
		CEntry	*entryP;

		if (countP0 == NULL) {
			if (maxEntriesL) {
				maxEntriesL = 1;
			}
		}
		
		for (
			curEntryL = 0;
			curEntryL < maxEntriesL;
			curEntryL++
		) {
			entryP = selectionP->GetIndEntry(curEntryL);
			if (entryP->i_type == FSObject_FOLDER) {
			
				if (folderP == NULL) {
					folderP = (CFolder *)entryP;
				}
				
				if (countP0) {
					(*countP0)++;
				}
			}
		}
		
		selectionP->Dispose();
	}
	
	return folderP;
}

void		CFinderWindow::DeSelectAll(void)
{
	Boolean			preparedB = i_prepared;
	CEntryArray		*selectionP = GetSelection();
	
	if (!preparedB) {
		Prepare();
	}
	
	if (selectionP) {	
		TA_Iterate_SELECTData	selectData;
		
		selectData.select	= FALSE;
		selectData.draw		= TRUE;
		
		(void)selectionP->Iterate(TA_Iterate_SELECT, &selectData);
		selectionP->Dispose();
	}
	
	if (!preparedB) {
		UnPrepare();
	}
}

void		CFinderWindow::UpdateMenus(void)
{
	ADFS_O_CBData_COUNT_TYPES	selection;
	ulong						totalCount = CountSelectedTypes(&selection);
	
	EnableCommand(cmdViewAsIcons);
	EnableCommand(cmdViewAsList);
	
	CheckCommand(cmdViewAsIcons,	i_header->i_viewAs == cmdViewAsIcons);
	CheckCommand(cmdViewAsList,		i_header->i_viewAs == cmdViewAsList);
	
	EnableCommand(cmdArrangeSub);
	AbleCommandGroup(cmdArrangeByIndex, cmdArrangeByLock, TRUE);
	CheckMenuGroup(
		GetMenuHandle(subArrange), 
		CommandItem(cmdArrangeByIndex), 
		CommandItem(cmdArrangeByLock), 
		CommandItem(ADFS_StatToCommand(i_header->i_arrangeBy)));

	if (selection.types & kDiskSelected) {
		
		if (selection.show_deleted == selection.disks) {
			CheckCommand(cmdShowDeleteFiles, TRUE);
		} else if (selection.show_deleted == 0) {
			CheckCommand(cmdShowDeleteFiles, FALSE);
		} else {
			DashCommand(cmdShowDeleteFiles, TRUE);
		}
	}

	if (selection.types & (kFileSelected | kFolderSelected | kDiskSelected)) {
		EnableCommand(cmdMoveToTrash);
	}

	if (selection.types & (kDeletedFileSelected | kFolderSelected | kDeletedFolderSelected | kDiskSelected)) {
		EnableCommand(cmdUndelete);
	}
		
	if (selection.types) {
		EnableCommand(cmdExport);
	}

	if (totalCount == 1) {
		if (
			(selection.types & kFolderSelected)
			|| selection.entryP->IsTranslatable()
			|| selection.entryP->IsGraphic()
		) {
			EnableCommand(cmdOpenFile);
		}
			
		if (selection.entryP->IsTranslatable()) {
			EnableCommand(cmdCopy);
		}

		EnableCommand(cmdGetInfo);
				
		if (
			selection.entryP->i_cDisk.gen->i_imageRec->osType == FSType_PRO
			&& selection.entryP->i_type != FSObject_DISK
		) {
			EnableCommand(cmdNewFolder);
		}
		
		if (selection.types & (kFolderSelected | kDiskSelected)) {
			EnableCommand(cmdImport);
		}
	} else {
		//	either lots or none are selected

		if (i_windowType == ADFS_Window_FOLDER) {
			EnableCommand(cmdNewFolder);
		}
	}

	_inherited::UpdateMenus();
}

void	CFinderWindow::Idle(void)
{
	_inherited::Idle();
}

void	CFinderWindow::DoKeyDown(EventRecord *event)
{
	if (i_renameTE) {
		_inherited::DoKeyDown(event);
	} else {
		char		ch			= VirtualASCII(event);
		Boolean		handledB	= FALSE;

		if (ch == DELETE_KEY) {
			handledB = DoCommand(cmdMoveToTrash);
		}
		
		if (ch == RETURN_KEY) {
			CEntry		*entryP;
			
			if (IsOneEntrySelected(&entryP)) {
				entryP->Rename();
				handledB = true;
			}
		}

		if (!handledB) {
			_inherited::DoKeyDown(event);
		}
	}
}

Boolean		CFinderWindow::DoCommand(long command)
{
	Boolean		handled = FALSE;
	
	if (i_renameTE) {
		handled = _inherited::DoCommand(command);
	}
	
	if (!handled) switch (CommandMenu(command)) {
		
		case subArrange: {
			handled = TRUE;
			i_header->DoCommand(command);
			break;
		}
	}

	if (!handled) switch (command) {
		
		case cmdNewDisk: {
			ADFS_NewDiskRec		diskRec;

			structclr(diskRec);
			diskRec = (**gPrefsH).newDiskRec;
			
			diskRec.diskP			= NULL;
			diskRec.NewDiskDoneCB	= NewDisk_CB;
			
			ShowNewDisk(&diskRec);
			break;
		}
		
		case cmdOpenFile: {
			CEntry		*entryP;
			
			if (IsOneEntrySelected(&entryP)) {
				entryP->Open();
			}
			break;
		}
		
		case cmdOpenDisk: {
			if (check_key_down(option_key)) {
				DoFakeCopy();
			} else {
				SelectFile();		// call file selection userProc
			}
			break;
		}

		case cmdViewAsIcons:
//		case cmdViewAsColumns:
		case cmdViewAsList: {
			handled = TRUE;
			i_header->DoCommand(command);
			break;
		}
		
		case cmdGetInfo: {
			CEntry		*entryP;
			
			if (IsOneEntrySelected(&entryP)) {
				ShowGetInfo(entryP, FALSE);
			}
			break;
		}
		
		case cmdImport: {
			FSSpec		fileSpec;
			CEntry		*entryP = NULL;
			CFolder		*folderP = NULL;
			
			if (IsOneEntrySelected(&entryP)) {
				if (entryP->i_type == FSObject_FOLDER) {
					folderP = (CFolder *)entryP;
				} else if (entryP->i_type == FSObject_DISK) {
					folderP = ((CDisk *)entryP)->i_rootDir.gen;
				} else {
					ASSERT("not a folder!");
				}
			}

			if (folderP && GetFileOrFolder(
				Nav_FileSelect_ANY_FILE, 
				c2p("Please choose what to import:"), 
				&fileSpec)
			) {
				OSErr	err = folderP->ADFS_SetPendingCopy(
					CCT_Copy_FSSPEC, CCT_Copy_ENTRY, 
					&fileSpec);
					
				if (err) ReportError(err);
			}
			break;
		}

		case cmdExport: {
			FSSpec		folderSpec;
			
			if (GetFileOrFolder(
				Nav_FileSelect_FOLDER, 
				c2p("Please choose the destination folder:"), 
				&folderSpec)
			) {
				OSErr			err			= noErr;
				CEntryArray		*selectionP = GetSelection();
				
				if (!err) err = FSpGetParentFolder(&folderSpec, &folderSpec);
				if (!err) err = ASSERT(selectionP);
				if (!err) {
					TA_Iterate_SET_PENDING_COPYData		copyData;
					
					copyData.folderSpecP	= &folderSpec;
					(void)selectionP->Iterate(TA_Iterate_SET_PENDING_COPY, &copyData);
					selectionP->Dispose();
				}
			}
			break;
		}
		
		case cmdNewFolder: {
			OSErr		err				= noErr;
			CEntry		*entryP			= NULL;
			CEntry		*folderP		= NULL;		
			CFolder		*parentFolderP	= NULL;		
			Boolean		selectedB		= FALSE;
			
			if (IsOneEntrySelected(&entryP)) {
				if (
					entryP->i_cDisk.gen->i_imageRec->osType != FSType_PRO
				) {
					entryP = NULL;
				} else {
					selectedB = TRUE;
				}
			} else if (i_windowType == ADFS_Window_FOLDER) {
				entryP = GetTopicEntry(i_topicRef.cTopic);
			}

			if (entryP) {
				if (entryP->i_type == FSObject_DISK) {
					parentFolderP = ((CDisk *)entryP)->i_rootDir.gen;
				} else if (
					!selectedB
					&& entryP->i_type == FSObject_FOLDER
				) {
					parentFolderP = (CFolder *)entryP;
				} else {
					parentFolderP = entryP->GetParentFolder();
				}

				ASSERT(parentFolderP);
				
				err = parentFolderP->NewFolder(&folderP);
			}

			if (!err && folderP) {
				if (folderP->i_cDisk.gen->i_diskMapP) {
					folderP->i_cDisk.gen->i_diskMapP->Refresh(folderP, TRUE);
				}

				Prepare();
				DeSelectAll();
				folderP->Select(TRUE, FALSE);
				UnPrepare();

				folderP->Rename();
			}
			break;
		}

		case cmdUndelete: {
			OSErr			err			= noErr;
			CEntryArray		*selectionP	= GetSelection();
			CEntryArray		*disksP		= GetDisksOfSelection(selectionP);
			
			if (selectionP && disksP) {
				Boolean		flushB;
				
				flushB = FALSE;
				err = disksP->Iterate(TA_Iterate_FLUSH_MEM_DISK, &flushB);
				if (!err) {
					OSErr		err2;

					err = disksP->Iterate(TA_Iterate_SET_SHOW_DELETED, NULL);
					
					if (!err) {
						ulong		totalL = 0;
						
						err = selectionP->Iterate(TA_Iterate_COUNT_RECURSE_DELETED, &totalL);
						
						if (!err) {
							CDialogCopy		*copyDialogP = ShowCopyDialog();

							if (copyDialogP) {
								copyDialogP->SetTitle("Undeleting Files");

								strcpy(
									copyDialogP->i_itemStrTable[DCpy_ItemStr_ITEM_REMAIN_STAT].itemStr, 
									"Files Remaining to be un-deleted:");
								
								copyDialogP->SetAsProgress(TRUE, totalL);
							}

							SetStandardCursor(watchCursor);
							err = selectionP->Iterate(TA_Iterate_UNDELETE, copyDialogP);
							InvalWindow(WindowRect_INTERIOR);
							
							if (copyDialogP) {
								copyDialogP->HideCopyDialog();
							}
						}

						err2 = disksP->Iterate(TA_Iterate_RESTORE_SHOW_DELETED, NULL);
						if (!err) err = err2;
					}

					flushB = TRUE;
					err2 = disksP->Iterate(TA_Iterate_FLUSH_MEM_DISK, &flushB);
					if (!err) err = err2;
				}
			}
			
			if (selectionP) selectionP->Dispose();
			if (disksP) disksP->Dispose();
			break;
		}
		
		case cmdMoveToTrash: {
			if (IsDiskSelected(NULL) == NULL) {
				CEntryArray		*selectionP	= GetSelFilesFolders();
				CEntryArray		*disksP		= GetDisksOfSelection(selectionP);
				
				if (selectionP && disksP) {
					if (selectionP->Count()) {
						CDialogCopy		*copyDialogP = ShowCopyDialog();
						
						if (copyDialogP) {
							ulong		totalL;
							
							handled = TRUE;
							
							copyDialogP->SetTitle("Deleting Files");

							strcpy(
								copyDialogP->i_itemStrTable[DCpy_ItemStr_ITEM_REMAIN_STAT].itemStr, 
								"Files Remaining to be deleted:");
							
							totalL = 0;
							
							if (selectionP->Iterate(TA_Iterate_COUNT_RECURSE, &totalL) == noErr) {
								Boolean		flushB;
								
								copyDialogP->SetAsProgress(TRUE, totalL);
								ResetDeleteFileDialog(kDlog_DeleteFile_ItemID_NONE);
								
								//	bad boy!  ignoring errors like that!
								flushB = FALSE;
								(void)disksP->Iterate(TA_Iterate_FLUSH_MEM_DISK, &flushB);
								
								SetStandardCursor(watchCursor);
								(void)selectionP->Iterate(TA_Iterate_DELETE, copyDialogP);
								InvalWindow(WindowRect_INTERIOR);

								flushB = TRUE;
								(void)disksP->Iterate(TA_Iterate_FLUSH_MEM_DISK, &flushB);
							}
		
							copyDialogP->HideCopyDialog();
						}
					}
				}
				
				if (selectionP) selectionP->Dispose();
				if (disksP) disksP->Dispose();
			}
			break;
		}

		case cmdCopy: {
			ulong	fileCount;
			CFile	*fileP;
			
			if ((fileP = (CFile *)IsFileSelected(&fileCount)) != NULL) {
				if (fileP->IsTranslatable()) {
					fileP->CopyFileTextToClipboard();
				}
			}
			break;
		}
		
		default: {
			handled = _inherited::DoCommand(command);
			break;
		}
	}
	
	return handled;
}

void		CFinderWindow::DoTopicClick(O_CTopic *cTopic, Point hitPoint, short modifiers)
{
	GetTopicEntry(cTopic)->DoClick(hitPoint, modifiers);
}

OSErr		CFinderWindow::DragTrack(
	DragTrackingMessage		message, 
	DragReference			theDrag)
{
	OSErr		err = noErr;
	
	switch (message) {
		
		default: {
			err = _inherited::DragTrack(message, theDrag);
			break;
		}
		
		case kDragTrackingEnterWindow: {
			err = _inherited::DragTrack(message, theDrag);
			break;
		}

		case kDragTrackingLeaveWindow: {
			err = _inherited::DragTrack(message, theDrag);

			if (i_dragHitTopic) {
				CEntry		*topic = GetTopicEntry(i_dragHitTopic);
				
				err = Prepare();
				if (!err) {
					topic->Hilight(FALSE);
					UnPrepare();
				}
				
				i_dragHitTopic = NULL;
			}
			break;
		}
	}

	return err;
}

OSErr		CFinderWindow::DragTrackInWindow(DragReference theDrag)
{
	OSErr			err = noErr;
	WindowRectType	pane;
	short			subPane;
	O_CTopic		*newDragHitTopic = NULL;
	Rect			hitRect;
	Point			hitPoint;
	CEntry			*newDragHitEntry = NULL;

	GetDragMouse(theDrag, &hitPoint, NULL);
	
	if (GetWindowHit(hitPoint, &pane, &subPane, &newDragHitTopic, &hitRect)) {
		
		if (
			pane == WindowRect_INTERIOR
			&& newDragHitTopic
		) {
			newDragHitEntry = GetTopicEntry(newDragHitTopic);
			
			//	if you hit a file, drop onto parent folder
			if (
				newDragHitEntry
				&& newDragHitEntry->i_type == FSObject_FILE
			) {
				newDragHitEntry = newDragHitEntry->GetParent();
				newDragHitTopic = newDragHitEntry->i_topicRef.cTopic;
			}
			
			//	only folders and disks allowed for dropping
			if (
				newDragHitEntry
				&& (
					newDragHitEntry->i_type != FSObject_FOLDER
					&& newDragHitEntry->i_type != FSObject_DISK
				)
			) {
				newDragHitEntry = NULL;
				newDragHitTopic = NULL;
			}
		}
		
		if (newDragHitEntry) {
			if (IsDragging()) {
				if (
					newDragHitEntry->IsSelected() 
					|| newDragHitEntry->IsAncestorSelected()
				) {
					//	no recursive drops
					newDragHitEntry = NULL;
					newDragHitTopic = NULL;
				}
			}
		}
	}
	
	if (newDragHitTopic != i_dragHitTopic) {
		
		if (!err) err = Prepare();
		if (!err) {
			RgnHandle	theRgn = NewRgn();
			
			if (theRgn) SetEmptyRgn(theRgn);

			if (i_dragHitTopic) {
				CEntry		*topic = GetTopicEntry(i_dragHitTopic);
				
				topic->Hilight(FALSE);
				if (theRgn) topic->GetBlitRgn(theRgn);
			}
			
			if (newDragHitEntry) {
				newDragHitEntry->Hilight(TRUE);
				if (theRgn) newDragHitEntry->GetBlitRgn(theRgn);
			}
			
			UnPrepare();

			if (theRgn) {
				Rect	rgnBBox;
				
				GetRegionBounds(i_frameRgn, &rgnBBox);
				OffsetRgn(theRgn, 0, rgnBBox.top);
				err = UpdateDragHilite(theDrag, theRgn);
				DisposeRgn(theRgn);
			}
			

			i_dragHitTopic = newDragHitTopic;
		}
	}
		
	return err;
}

OSErr	CFinderWindow::CanAcceptFlavor(
	DragReference	theDrag, 
	ItemReference	itemRef, 
	FlavorType		flavorType, 
	Boolean			*goodFlavorB)
{
	OSErr		err = noErr;
	
	if (flavorType == kDragFlavorTypeADFS) {
		*goodFlavorB = TRUE;
	}
	
	return err;
}

OSErr		CFinderWindow::DragReceiveFlavor(
	DragReference	theDrag, 
	ItemReference	itemRef, 
	FlavorType		flavorType, 
	void			*data)
{
	OSErr		err = noErr;
	
	if (i_dragHitTopic) {
		CEntry		*entryP = GetTopicEntry(i_dragHitTopic);
		
		switch (flavorType) {

			case kDragFlavorTypeADFS: {
				entryP->DragReceiveFlavor(theDrag, itemRef, flavorType, data);
				break;
			}

			case flavorTypeHFS: {
				entryP->DragReceiveFlavor(theDrag, itemRef, flavorType, data);
				break;
			}
		}
	}
	
	return err;
}
